using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;

namespace TcpEchoClient
{
    public partial class Form1 : Form
    {
		TcpClient tcpClient;
        public Form1()
        {
            InitializeComponent();
        }

        private void sendButton_Click(object sender, EventArgs e)
        {
            Byte[] data = System.Text.Encoding.ASCII.GetBytes(sentText.Text);
            tcpClient.GetStream().Write(data, 0, data.Length);
        }

        private void connectButton_Click(object sender, EventArgs e)
        {
            string sComputer = computerName.Text;
            if (sComputer.Length == 0)
                sComputer = "127.0.0.1";

            tcpClient = new TcpClient();
            tcpClient.Connect(sComputer, 15555);
            timer1.Enabled = true;
            connectButton.Enabled = false;
            sendButton.Enabled = true;
            disconnectButton.Enabled = true;
        }

        private void disconnectButton_Click(object sender, EventArgs e)
        {
            timer1.Enabled = false;
            tcpClient.Close();
            disconnectButton.Enabled = false;
            sendButton.Enabled = false;
            connectButton.Enabled = true;
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            Byte[] returnedData = new Byte[1024];
            if (tcpClient.GetStream().DataAvailable)
            {
                tcpClient.GetStream().Read(returnedData, 0, 1024);
                echoText.Text = System.Text.Encoding.ASCII.GetString(returnedData);
            }
        }
	}
}
