using System;
using System.IO;
using System.Runtime.InteropServices;

namespace Win32
{
    /// <summary>
    /// Summary description for Class1
    /// </summary>
    [
    System.Runtime.InteropServices.ComVisible(false),
    System.Security.SuppressUnmanagedCodeSecurityAttribute()
    ]
    public class Win32IO
    {
        // Some Win32 API constants
        public const int 
            INVALID_HANDLE_VALUE    = (-1),
            NULL                    = 0,
            
            ERROR_SUCCESS           = 0,
            ERROR_INVALID_FUNCTION  = 1,

            //  Access Rights
            FILE_READ_DATA          = (0x0001),
            FILE_WRITE_DATA         = (0x0002),
            FILE_READ_ACCESS        = (0x0001),    // file & pipe
            FILE_WRITE_ACCESS       = (0x0002),    // file & pipe

            //  File Access Modes
            GENERIC_READ            = unchecked((int)0x80000000),
            GENERIC_WRITE           = 0x40000000,
            FILE_SHARE_READ         = 0x00000001,
            FILE_SHARE_WRITE        = 0x00000002,
            CREATE_NEW              = 1,
            CREATE_ALWAYS           = 2,
            OPEN_EXISTING           = 3,
            OPEN_ALWAYS             = 4,
            TRUNCATE_EXISTING       = 5,

            METHOD_BUFFERED         = 0,
                            
            METHOD_NEITHER          = 3,
            FILE_ANY_ACCESS         = 0,
            
            // IoControlCode values for disk devices.
            FILE_DEVICE_DISK        = 0x00000007,
            IOCTL_DISK_BASE         = FILE_DEVICE_DISK,
            FILE_DEVICE_VIRTUAL_DISK = 0x00000024,

            // IoControlCode values for storage devices.
            FILE_DEVICE_MASS_STORAGE= 0x0000002d,
            IOCTL_STORAGE_BASE      = FILE_DEVICE_MASS_STORAGE;


        //IOCTL code functions (instead of C/C++ macros)
        public static int CTL_CODE(int DeviceType, int Function, int Method, int Access)
        {
            return
              (((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method));
        }

        public static int DEVICE_TYPE_FROM_CTL_CODE(int ctrlCode)
        {
            return (int)((ctrlCode & 0xffff0000) >> 16);
        }

        // Definitions of IOCTL codes for disk devices
        public static int IOCTL_DISK_GET_DRIVE_GEOMETRY()
           { return CTL_CODE(IOCTL_DISK_BASE, 0x0000, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_GET_PARTITION_INFO()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0001, METHOD_BUFFERED, FILE_READ_ACCESS); }
        public static int IOCTL_DISK_SET_PARTITION_INFO()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0002, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS); }
        public static int IOCTL_DISK_GET_DRIVE_LAYOUT()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0003, METHOD_BUFFERED, FILE_READ_ACCESS); }
        public static int IOCTL_DISK_SET_DRIVE_LAYOUT()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0004, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS); }
        public static int IOCTL_DISK_VERIFY()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0005, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_FORMAT_TRACKS()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0006, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS); }
        public static int IOCTL_DISK_REASSIGN_BLOCKS()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0007, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS); }
        public static int IOCTL_DISK_PERFORMANCE()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0008, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_IS_WRITABLE()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0009, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_LOGGING()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x000a, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_FORMAT_TRACKS_EX()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x000b, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS); }
        public static int IOCTL_DISK_HISTOGRAM_STRUCTURE()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x000c, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_HISTOGRAM_DATA()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x000d, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_HISTOGRAM_RESET()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x000e, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_REQUEST_STRUCTURE()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x000f, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_REQUEST_DATA()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0010, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_PERFORMANCE_OFF()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0018, METHOD_BUFFERED, FILE_ANY_ACCESS); }

        public static int IOCTL_DISK_CONTROLLER_NUMBER()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0011, METHOD_BUFFERED, FILE_ANY_ACCESS); }

        // Smart drive fault prediction
        public static int SMART_GET_VERSION()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0020, METHOD_BUFFERED, FILE_READ_ACCESS); }
        public static int SMART_SEND_DRIVE_COMMAND()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0021, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS); }
        public static int SMART_RCV_DRIVE_DATA()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0022, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS); }

        // New IOCTLs for GUID Partition tabled disks.
        public static int IOCTL_DISK_GET_PARTITION_INFO_EX()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0012, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_SET_PARTITION_INFO_EX()    
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0013, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS); }
        public static int IOCTL_DISK_GET_DRIVE_LAYOUT_EX()      
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0014, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_DISK_SET_DRIVE_LAYOUT_EX()      
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0015, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS); }
        public static int IOCTL_DISK_CREATE_DISK()              
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0016, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS); }
        public static int IOCTL_DISK_GET_LENGTH_INFO()          
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0017, METHOD_BUFFERED, FILE_READ_ACCESS); }
        public static int IOCTL_DISK_GET_DRIVE_GEOMETRY_EX()
            { return CTL_CODE(IOCTL_DISK_BASE, 0x0028, METHOD_BUFFERED, FILE_ANY_ACCESS); }

        // Definitions of IOCTL codes for all storage devices - NOT ALL CODES !!!

        public static int IOCTL_STORAGE_CHECK_VERIFY()
            { return CTL_CODE(IOCTL_STORAGE_BASE, 0x0200, METHOD_BUFFERED, FILE_READ_ACCESS); }
        public static int IOCTL_STORAGE_CHECK_VERIFY2()           
            { return CTL_CODE(IOCTL_STORAGE_BASE, 0x0200, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_STORAGE_MEDIA_REMOVAL()           
            { return CTL_CODE(IOCTL_STORAGE_BASE, 0x0201, METHOD_BUFFERED, FILE_READ_ACCESS); }
        public static int IOCTL_STORAGE_EJECT_MEDIA()             
            { return CTL_CODE(IOCTL_STORAGE_BASE, 0x0202, METHOD_BUFFERED, FILE_READ_ACCESS); }
        public static int IOCTL_STORAGE_LOAD_MEDIA()              
            { return CTL_CODE(IOCTL_STORAGE_BASE, 0x0203, METHOD_BUFFERED, FILE_READ_ACCESS); }
        public static int IOCTL_STORAGE_LOAD_MEDIA2()             
            { return CTL_CODE(IOCTL_STORAGE_BASE, 0x0203, METHOD_BUFFERED, FILE_ANY_ACCESS); }
        public static int IOCTL_STORAGE_RESERVE()                 
            { return CTL_CODE(IOCTL_STORAGE_BASE, 0x0204, METHOD_BUFFERED, FILE_READ_ACCESS); }
        public static int IOCTL_STORAGE_RELEASE()                 
            { return CTL_CODE(IOCTL_STORAGE_BASE, 0x0205, METHOD_BUFFERED, FILE_READ_ACCESS); }
        public static int IOCTL_STORAGE_FIND_NEW_DEVICES()        
            { return CTL_CODE(IOCTL_STORAGE_BASE, 0x0206, METHOD_BUFFERED, FILE_READ_ACCESS); }

        [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
        public struct SECURITY_ATTRIBUTES {
            public int      nLength ;         
            public IntPtr   lpSecurityDescriptor;
            public bool     bInheritHandle;
        }

        [DllImport("Kernel32.dll", ExactSpelling = true, CharSet = CharSet.Auto, SetLastError = true)]
        public static extern bool CloseHandle(int hHandle);

        // CreateFile is is Overloaded for having SecurityAttributes or not 
        
        [DllImport("Kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern int CreateFile(
            String lpFileName,
            int dwDesiredAccess, 
            int dwShareMode,
            IntPtr lpSecurityAttributes, 
            int dwCreationDisposition,
            int dwFlagsAndAttributes, 
            int hTemplateFile);

        [DllImport("Kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern int CreateFile(
            String lpFileName,
            int dwDesiredAccess, 
            int dwShareMode,
            ref SECURITY_ATTRIBUTES lpSecurityAttributes,
            int dwCreationDisposition,
            int dwFlagsAndAttributes, 
            int hTemplateFile);

        // DeviceIoControl is Overloaded for byte or int data

        [DllImport("Kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern bool DeviceIoControl(
            int hDevice, 
            int dwIoControlCode, 
            byte[] InBuffer, 
            int nInBufferSize, 
            byte[] OutBuffer, 
            int nOutBufferSize, 
            ref int pBytesReturned, 
            int pOverlapped);

        [DllImport("Kernel32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern bool DeviceIoControl(
            int hDevice, 
            int dwIoControlCode, 
            int[] InBuffer, 
            int nInBufferSize,
            int[] OutBuffer, 
            int nOutBufferSize, 
            ref int pBytesReturned, 
            int pOverlapped);
     }
}