// DrvTestCPP.h : Defines the entry point for the console application.
//


/*** Partition information Ex definitions ***/

typedef enum _PARTITION_STYLE
{
	PARTITION_STYLE_MBR,
	PARTITION_STYLE_GPT,
	PARTITION_STYLE_RAW
}	PARTITION_STYLE;

typedef struct _PARTITION_INFORMATION_MBR 
{  
	BYTE PartitionType;
	BOOLEAN BootIndicator;
	BOOLEAN RecognizedPartition;
	DWORD HiddenSectors;
} PARTITION_INFORMATION_MBR;

typedef struct _PARTITION_INFORMATION_GPT 
{
	GUID  PartitionType;  
	GUID  PartitionId;  
	ULONG64  Attributes;  
	WCHAR Name[36];
} PARTITION_INFORMATION_GPT, *PPARTITION_INFORMATION_GPT;

typedef struct 
{  
	PARTITION_STYLE PartitionStyle;
	LARGE_INTEGER StartingOffset;
	LARGE_INTEGER PartitionLength;
	DWORD PartitionNumber;  
	BOOLEAN RewritePartition;  
	union 
	{    
		PARTITION_INFORMATION_MBR Mbr;
		PARTITION_INFORMATION_GPT Gpt;  
	};
} PARTITION_INFORMATION_EX;

#define IOCTL_DISK_GET_PARTITION_INFO_EX CTL_CODE(IOCTL_DISK_BASE,0x12,METHOD_BUFFERED,FILE_ANY_ACCESS)
